
# ---- Oxygen profile GIF-maker script ----------- #

par(mfrow = c(1,3))
library(imager)
library(matrixStats)
library(scales)
library(gtools)
library(inflection)
options(scipen = 999)

rootDirectory = 'F:/Manuscripts/Chapter 1 Manuscript submission & data/4TU Data/Figure S9 - oxygen GIF/'
outputDirectory = paste(rootDirectory, 'GIF/', sep = '')
hummockDirectory = paste(rootDirectory, 'Data Photos/Hummock', sep = '')
hollowDirectory = paste(rootDirectory, 'Data Photos/Hollow', sep = '')
flatDirectory = paste(rootDirectory, 'Data Photos/Flat', sep = '')

letterLabel = c('B','C','A')
interval = 120  # 2min=120s between adjacent two images

setwd(outputDirectory)
png('%04d.png',width = 12, height = 5, units = 'in', res = 300)
for(i in 1:151){
  for (i_sedimentShape in c(3,1,2)){
    if(i_sedimentShape == 1){
      inputDirectory = flatDirectory
      sedimentSurfaceDepth.cm = 3.33 # cm
      title = 'Flat'
      ybottom = 4
      ytop = 3
      color = 'green'
      photoSeq = 1152:(1152 + 150)
    } else if (i_sedimentShape == 2){
      inputDirectory = hummockDirectory
      sedimentSurfaceDepth.cm = 2.33 # cm
      title = 'Hummock'
      color = 'blue'
      photoSeq = 550:(550 + 150)
    } else if (i_sedimentShape == 3){
      par(mfrow = c(1,3))
      inputDirectory = hollowDirectory      
      sedimentSurfaceDepth.cm = 4.33 # cm
      title = 'Hollow'
      ybottom = 4
      ytop = 2
      color = 'yellow'
      photoSeq = 223:(223 + 150)
    }
    
    # make a list for sorted images in the file folder
    setwd(inputDirectory)
    filelist = mixedsort(dir())
    
    #i = round(runif(n = 1, min = 1, max = length(filelist)))
    setwd(inputDirectory)
    filename = filelist[photoSeq[i]]
    
    # load images, grayscale, crop, convert class from image to matrix
    p = load.image(filename)
    p.g = grayscale(p)
    p.g.c = as.cimg(p.g[205:660,120:710, 1, 1])
    m = as.matrix(p.g.c)
    m = m*100
    
    # synchronize depth layers in cm and in pixel
    depth = seq(0,6.24, length.out = dim(m)[2]) - sedimentSurfaceDepth.cm # depth in "cm"
    
    # calculate the mean values and SE in columns
    se = colSds(m)/sqrt(dim(m)[1])
    oxygen.mean = colMeans(m)
    x = oxygen.mean
    interval = 5
    xMean = c()
    for(i_window in 1:length(x)){
      start = i_window
      end = start + interval
      
      xMean[i_window] = mean(x[start:end], na.rm = T)
    }
    
    #plot the oxygen concentration vs depth
    setwd(outputDirectory)
    plot(c(1), xlim = c(0.0005,100),ylim = c(4,-2), log ='',
         type = 'n',
         xlab = 'Oxygen saturation (%)', ylab = 'Depth (cm)')
    lines(x = c(0,100), y = c(0,0), lty = 2, lwd = 2, col = alpha('black',0.5))
    text('Sediment surface', x = 20, y = -0.5, col = alpha('black',0.5))
    title(title)
    if(i_sedimentShape != 2){
      rect(ybottom = ybottom, ytop = ytop, xleft = 100, xright = 0, lty = 0, col = alpha('black',0.1))
      text('Out of frame', x = 50, y = mean(c(ybottom,ytop)))
    }
    filter = depth > -2
    points(depth[filter] ~ oxygen.mean[filter], pch = '.')
    
    inflectionPoint = bese(depth, xMean, index = 1)$iplast
    filter = which.min(abs(xMean - 50))
    points(depth[filter] ~ xMean[filter], cex = 2, pch = 21, bg = alpha(color,0.5))
    
    filter = (depth > inflectionPoint)# & (xMean > 10)
    y = oxygen.mean[filter]
    x = depth[filter] - min(depth[filter])
    c = 1.4
    m = nls(y ~ exp(a + b*x) + c, start = list(a = 3.8, b = -3.5))
    summary(m)
    a = summary(m)$coefficients[1]
    b = summary(m)$coefficients[2]
    xv = seq(0,3, length.out = 1000)
    yv = exp(a + b*xv) + c
    xv2 = xv + min(depth[filter])
    lineFilter = xv2 < max(depth) & yv < 50
    lines(xv2[lineFilter] ~ yv[lineFilter], col = alpha(color,0.5), lwd = 2)
    
    text(x = 5, y = -1.8, letterLabel[i_sedimentShape], cex = 2)
  }
  print(paste(i,'/',151))
}
dev.off() 
#Mac:
#system("convert -delay 10 *.png Figure S9.gif")
#Windows:
system('"C:/Program Files/ImageMagick-7.0.10-Q16/magick.exe" -delay 10 *.png Figure S9.gif', intern = TRUE)

# file.remove(list.files(pattern=".png"))
